﻿namespace Microsoft.Samples.PlanMyNight.AddIns.Share.Controllers
{
    using System.ComponentModel.Composition;
    using System.Web.Mvc;
    using Microsoft.Samples.PlanMyNight.AddIns.Share.Models;
    using Microsoft.Samples.PlanMyNight.Infrastructure;
    using Microsoft.Samples.PlanMyNight.Infrastructure.Mvc;

    [Export("Sharing", typeof(IController))]
    [PartCreationPolicy(CreationPolicy.NonShared)]
    [OutputCache(NoStore = true, Duration = 0, VaryByParam = "*")]
    public class SharingController : Controller
    {
        private readonly IShortenUrlService urlService;

        [ImportingConstructor]
        public SharingController(IShortenUrlService urlService)
        {
            this.urlService = urlService;
        }

        public ActionResult ShortUrl(string url)
        {
            var shortUrl = this.urlService.GeneratedShortUrl(url);

            if (this.IsAjaxCall())
            {
                return new JsonResult
                {
                    JsonRequestBehavior = JsonRequestBehavior.AllowGet,
                    Data = shortUrl
                };
            }
            else
            {
                ViewData.Model = shortUrl;
                return View("ShortUrl");
            }
        }

        public PartialViewResult ShortUrlToolbox()
        {
            return PartialView("ShortUrlToolbox");
        }

        public PartialViewResult ShareToolbox(string url, string title)
        {
            ViewData["title"] = title;
            ViewData["url"] = url;
            return PartialView("ShareToolbox");
        }
    }
}
